# To switch between using a custom map or a seed generated map simply hash # tag the line
# that you don't want to be loaded into the start up arguments. Adding a hash at the start
# of the line tells the script to ignore the argument on that line.


def get_custom_args():
    args = [
#        f"+server.levelurl", "https://type-your-custom-map-url-here.com",
        "+server.seed", "93509994", "+server.worldsize", "3700",

        "+server.maxplayers", "50",             # Maximum number of players that can connect to your server at one time
        "+server.hostname", "Rust Server Name", # This name is what will appear in the Rust in-game server listing
        "+server.description", "",              #(Optional) Info about what players can expect to experience while playing the server. Mods, game settings, welcome message, play style etc.
        "+server.headerimage", "",              #(Optional) An image URL can be put here, typically a group themed banner, which is displayed with the server description
        "+server.url", "",                      #(Optional) A group website or forum URL can be placed here which players can access from the "External Website" button in the description
        
        "+server.port", "28070",                # To make your Rust server publicly visible you must forward this port
        "+server.queryport", "28071",           # Also forward this port
        "+app.port", "28072",                   # And also forward this port
        "+rcon.password", "12345"               # ****Please change the rcon password to something unique****
    ]


# THE ABOVE PORTS +server.port, +server.queryport, +app.port CAN NOT BE ANYTHING
# IN THE RANGE OF NUMBER 28000 - 28049 OTHERWISE IT WILL CREATE PORT CONFLICTS
################################################################################
######################## DON'T EDIT ANYTHING BELOW HERE ########################

    uses_levelurl = any(arg.startswith("+server.levelurl") for arg in args)
    uses_seed = any(arg.startswith("+server.seed") for arg in args)
    uses_worldsize = any(arg.startswith("+server.worldsize") for arg in args)

    map_mode = "url" if uses_levelurl else "seed" if uses_seed and uses_worldsize else "unknown"
    seed = next((args[i + 1] for i, a in enumerate(args) if a == "+server.seed"), None)
    worldsize = next((args[i + 1] for i, a in enumerate(args) if a == "+server.worldsize"), None)

    return args, {
        "map_mode": map_mode,
        "seed": seed,
        "worldsize": worldsize
    }

