using System.Linq;

namespace Oxide.Plugins
{
    [Info("ForceRespawn", "Im_just_a_Pixel", "1.0.4")]
    [Description("Allows admins to force-respawn dead players using a console command.")]

    public class ForceRespawn : RustPlugin
    {
        [ConsoleCommand("respawnplayer")]
        private void CmdRespawn(ConsoleSystem.Arg arg)
        {
            if (!arg.IsAdmin)
            {
                arg.ReplyWith("You must be an admin to use this command.");
                return;
            }

            if (arg.Args == null || arg.Args.Length < 1)
            {
                arg.ReplyWith("Usage: respawn <partial or full player name>");
                return;
            }

            string search = string.Join(" ", arg.Args).ToLower();

            var matches = BasePlayer.activePlayerList
                .Where(p => p != null && p.IsDead() && p.displayName != null && p.displayName.ToLower().Contains(search))
                .ToList();

            if (matches.Count == 0)
            {
                arg.ReplyWith($"No dead player found matching '{search}'.");
                return;
            }

            if (matches.Count > 1)
            {
                arg.ReplyWith($"Multiple matches found: {string.Join(", ", matches.Select(p => p.displayName))}");
                return;
            }

            BasePlayer target = matches[0];
            target.Respawn();
            target.SendNetworkUpdateImmediate();

            timer.Once(1f, () =>
            {
                if (target != null && target.IsConnected && !target.IsDead())
                {
                    if (target.IsSleeping())
                    {
                        target.EndSleeping();
                        Puts($"Respawned and woke up player: {target.displayName}");
                    }
                }
            });
        }
    }
}