using Oxide.Core.Plugins;
using Oxide.Game.Rust.Cui;
using Newtonsoft.Json;
using System.Collections.Generic;
using System.IO;
using UnityEngine;

namespace Oxide.Plugins
{
    [Info("DumpItems", "Assistant", "1.0.0")]
    [Description("Creates a JSON dump of all current game items with there names.")]

    public class DumpItems : RustPlugin
    {
        [ConsoleCommand("dump.items")]
        private void DumpItemList(ConsoleSystem.Arg arg)
        {
            var itemList = new List<object>();

            foreach (var def in ItemManager.itemList)
            {
                itemList.Add(new
                {
                    shortname = def.shortname,
                    displayName = def.displayName.english,
                    category = def.category.ToString()
                });
            }

            string filePath = $"{Directory.GetCurrentDirectory()}/oxide/data/items.json";
            File.WriteAllText(filePath, JsonConvert.SerializeObject(itemList, Formatting.Indented));

            Puts("Item data dumped to data/items.json");
        }
    }
}

