from http.server import BaseHTTPRequestHandler, HTTPServer
from rcon.source import Client
from urllib.parse import urlparse, parse_qs
from pathlib import Path
import ServerStartupArgs
import socket
import time
import os
import glob
import subprocess
import sys
import ctypes
import psutil
import json
import threading
import platform
import cgi

ctypes.windll.kernel32.SetConsoleTitleW("RconServerFour")
BASE_DIR = Path(__file__).resolve().parent

RCON_HOST = "127.0.0.1"
RCON_PORT = 28044
HTTP_PORT = 28040
RUST_SERVER_ID = "RustServerFour"
RCON_TIMEOUT = 1 # seconds
LOG_OUTPUT_PATH = BASE_DIR / "Console Logs" / "logfile.log"
WEBMINIMAP_DEAD_DATA = BASE_DIR / "Server_Data" / "oxide" / "data" / "WebMinimap.json"
PLAYER_REWARDER_DATA = BASE_DIR / "Server_Data" / "oxide" / "data" / "PlayerRewarder.json"
PLUGIN_DIRECTORY = BASE_DIR / "Server_Data" / "oxide" / "plugins"
args, _ = ServerStartupArgs.get_custom_args()
RCON_PASSWORD = args[args.index("+rcon.password") + 1]

time.sleep(1)

class SimpleWebhookHandler(BaseHTTPRequestHandler):
    def _set_headers(self, status_code=200):
        self.send_response(status_code)
        self.send_header('Access-Control-Allow-Origin', '*')
        self.send_header('Content-type', 'text/plain')
        self.end_headers()
        
    def _json_response(self, obj, status=200):
        self.send_response(status)
        self.send_header("Content-Type", "application/json")
        self.send_header("Access-Control-Allow-Origin", "*")
        self.end_headers()
        self.wfile.write(json.dumps(obj).encode())    

    def do_OPTIONS(self):
        self.send_response(200)
        self.send_header('Access-Control-Allow-Origin', '*')
        self.send_header('Access-Control-Allow-Methods', 'POST, PUT, OPTIONS')
        self.send_header('Access-Control-Allow-Headers', '*')
        self.end_headers()

    def do_POST(self):
        from urllib.parse import urlparse
        parsed_path = urlparse(self.path)
        if parsed_path.path == '/Mod_Upload':
            try:
                ctype, pdict = cgi.parse_header(self.headers.get('Content-Type'))
                if ctype != 'multipart/form-data':
                    self.send_response(400)
                    self.send_header('Content-Type', 'application/json')
                    self.send_header('Access-Control-Allow-Origin', '*')
                    self.end_headers()
                    self.wfile.write(json.dumps({
                        "success": False,
                        "message": "Content-Type must be multipart/form-data"
                    }).encode('utf-8'))
                    return

                form = cgi.FieldStorage(
                    fp=self.rfile,
                    headers=self.headers,
                    environ={'REQUEST_METHOD': 'POST'},
                    keep_blank_values=True
                )

                if 'file' not in form:
                    raise ValueError("Missing file field")

                mod_file = form['file']
                if not mod_file.filename:
                    raise ValueError("No file uploaded")

                filename = Path(mod_file.filename).name
                file_path = PLUGIN_DIRECTORY / filename

                with open(file_path, 'wb') as f:
                    f.write(mod_file.file.read())

                append_to_log(f"✅ Successfully saved mod: {filename}")

                self.send_response(200)
                self.send_header('Content-Type', 'application/json')
                self.send_header('Access-Control-Allow-Origin', '*')
                self.end_headers()
                self.wfile.write(json.dumps({
                    "success": True,
                    "filename": filename,
                    "path": str(file_path)
                }).encode('utf-8'))

            except ValueError as e:
                self.send_response(400)
                self.send_header('Content-Type', 'application/json')
                self.send_header('Access-Control-Allow-Origin', '*')
                self.end_headers()
                self.wfile.write(json.dumps({
                    "success": False,
                    "message": str(e)
                }).encode('utf-8'))
                append_to_log(f"❌ Failed to save mod upload: {e}")

            except Exception as e:
                self.send_response(500)
                self.send_header('Content-Type', 'application/json')
                self.send_header('Access-Control-Allow-Origin', '*')
                self.end_headers()
                self.wfile.write(json.dumps({
                    "success": False,
                    "message": "Internal server error"
                }).encode('utf-8'))
                append_to_log(f"❌ Failed to save mod upload: {e}")

            return
        
    def do_PUT(self):
        # === RCON CONTROL ENDPOINTS ===
        if self.path == '/Fast_Restart':
            try:
                rcon_client = Client(RCON_HOST, RCON_PORT, passwd=RCON_PASSWORD, timeout=RCON_TIMEOUT)
                try:
                    rcon_client.connect(login=True)
                finally:
                    rcon_client.run("quit")
                    rcon_client.close()
                    print("🔌 RCON connection closed")
                    
            except Exception as e:
                self.send_response(200)
                self.end_headers()
                self.wfile.write(f"Command Received: {e}".encode())

        elif self.path == '/Delayed_Restart':
            try:
                rcon_client = Client(RCON_HOST, RCON_PORT, passwd=RCON_PASSWORD, timeout=RCON_TIMEOUT)
                try:
                    rcon_client.connect(login=True)
                finally:
                    rcon_client.run("restart 120 Admin")
                    rcon_client.close()
                    print("🔌 RCON connection closed")
                    
            except Exception as e:
                self.send_response(200)
                self.end_headers()
                self.wfile.write(f"Command Received: {e}".encode())

        elif self.path == '/Custom_Command':
            try:
                content_length = int(self.headers.get('Content-Length', 0))
                command = self.rfile.read(content_length).decode('utf-8').strip()
                if not command:
                    self.send_response(400)
                    self.end_headers()
                    self.wfile.write(b"No command provided.\n")
                    return

                rcon_client = Client(RCON_HOST, RCON_PORT, passwd=RCON_PASSWORD, timeout=RCON_TIMEOUT)
                try:
                    rcon_client.connect(login=True)
                finally:
                    rcon_client.run(command)
                    rcon_client.close()
                    print("🔌 RCON connection closed")

            except Exception as e:
                self.send_response(200)
                self.end_headers()
                self.wfile.write(f"Command Received: {e}".encode())

        elif self.path == '/Full_Wipe':
            append_to_log("Server full wipe initiated...")
            time.sleep(3)
            append_to_log("Stopping Rust Test Server...")
            WIPE_DIRECTORY = BASE_DIR / "Server_Data" / "server" / RUST_SERVER_ID
            WIPE_PATTERNS = ["*.db", "*.db-wal", "*.sav", "*.map", "*.dat", "*.1", "*.2"]

            try:
                kill_rust_server()
                time.sleep(5)                
                deleted_files = []
                print("Files in directory before deletion:", os.listdir(WIPE_DIRECTORY))
                append_to_log(f"📂 Files in directory before deletion: {os.listdir(WIPE_DIRECTORY)}")
                time.sleep(2)

                for pattern in WIPE_PATTERNS:
                    full_pattern = os.path.join(WIPE_DIRECTORY, pattern)
                    for file_path in glob.glob(full_pattern):
                        try:
                            os.remove(file_path)
                            deleted_files.append(os.path.basename(file_path))
                            print(f"❌ Deleted: {file_path}")
                            append_to_log(f"❌ Deleted: {file_path}")
                        except PermissionError as pe:
                            print(f"❌ Permission denied: {pe}")
                        except Exception as e:
                           print(f"❌ Error deleting {file_path}: {e}")
                           
                # Delete extra data files
                for extra_file in [WEBMINIMAP_DEAD_DATA, PLAYER_REWARDER_DATA]:
                    try:
                        if os.path.exists(extra_file):
                            os.remove(extra_file)
                            deleted_files.append(os.path.basename(extra_file))
                            print(f"❌ Deleted: {extra_file}")
                            append_to_log(f"❌ Deleted: {extra_file}")
                    except Exception as e:
                        print(f"❌ Error deleting {extra_file}: {e}")

                time.sleep(2)
                print("Files in directory after deletion:", os.listdir(WIPE_DIRECTORY))
                append_to_log(f"📂 Files in directory after deletion: {os.listdir(WIPE_DIRECTORY)}")
                append_to_log("✅ Full Wipe completed successfully.")
                time.sleep(5)
                append_to_log("🖥 Restarting the server console...")
                start_rust_server()

                self._set_headers(200)
                msg = f"✅ Full Wipe Complete. Deleted: {', '.join(deleted_files)}"
                self.wfile.write(msg.encode())

            except Exception as e:
                self._set_headers(500)
                error_msg = f"❌ Failed to perform full wipe: {e}"
                self.wfile.write(error_msg.encode())

        elif self.path == '/Half_Wipe':
            append_to_log("Server half wipe initiated...")
            time.sleep(3)
            append_to_log("Stopping Rust Test Server...")
            WIPE_DIRECTORY = BASE_DIR / "Server_Data" / "server" / RUST_SERVER_ID
            WIPE_PATTERNS = ["*.db", "*.db-wal", "*.sav", "*.map", "*.dat", "*.1", "*.2"]
            EXCLUDE_FILES = {"player.blueprints.5.db", "player.blueprints.5.db-wal"}

            try:
                kill_rust_server()
                time.sleep(5)
                deleted_files = []
                print("Files in directory before deletion:", os.listdir(WIPE_DIRECTORY))
                append_to_log(f"📂 Files in directory before deletion: {os.listdir(WIPE_DIRECTORY)}")
                time.sleep(2)

                for pattern in WIPE_PATTERNS:
                    full_pattern = os.path.join(WIPE_DIRECTORY, pattern)
                    for file_path in glob.glob(full_pattern):
                        filename = os.path.basename(file_path)

                        # Skip excluded files
                        if filename in EXCLUDE_FILES:
                            print(f"⚠️ Skipping excluded file: {filename}")
                            append_to_log(f"⚠️ Skipping blueprint files: {filename}")
                            continue

                        try:
                            os.remove(file_path)
                            deleted_files.append(filename)
                            print(f"❌ Deleted: {file_path}")
                            append_to_log(f"❌ Deleted: {file_path}")
                        except PermissionError as pe:
                            print(f"❌ Permission denied: {pe}")
                        except Exception as e:
                            print(f"❌ Error deleting {file_path}: {e}")
                            
                # Delete extra data files
                for extra_file in [WEBMINIMAP_DEAD_DATA, PLAYER_REWARDER_DATA]:
                    try:
                        if os.path.exists(extra_file):
                            os.remove(extra_file)
                            deleted_files.append(os.path.basename(extra_file))
                            print(f"❌ Deleted: {extra_file}")
                            append_to_log(f"❌ Deleted: {extra_file}")
                    except Exception as e:
                        print(f"❌ Error deleting {extra_file}: {e}")

                time.sleep(2)
                print("Files in directory before deletion:", os.listdir(WIPE_DIRECTORY))
                append_to_log(f"📂 Files in directory after deletion: {os.listdir(WIPE_DIRECTORY)}")
                append_to_log("✅ Half Wipe completed successfully.")
                time.sleep(5)
                append_to_log("🖥 Restarting the server console...")
                start_rust_server()

                self._set_headers(200)
                msg = f"✅ Half Wipe Complete. Deleted: {', '.join(deleted_files)}"
                self.wfile.write(msg.encode())

            except Exception as e:
                self._set_headers(500)
                error_msg = f"❌ Failed to perform half wipe: {e}"
                self.wfile.write(error_msg.encode())

        elif self.path == '/Add_Mod':
            try:
                content_length = int(self.headers.get('Content-Length', 0))
                mod_name = self.rfile.read(content_length).decode('utf-8').strip()

                if not mod_name:
                    self._set_headers(400)
                    self.wfile.write(b"No mod name provided.\n")
                    return

                if not mod_name.lower().endswith('.cs'):
                    mod_name += '.cs'

                download_url = f"https://umod.org/plugins/{mod_name}"
                destination_path = BASE_DIR / "Server_Data" / "oxide" / "plugins" / mod_name

                # Prepare request with headers
                import urllib.request
                req = urllib.request.Request(
                    download_url,
                    headers={'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'}
                )
                with urllib.request.urlopen(req) as response, open(destination_path, 'wb') as out_file:
                    out_file.write(response.read())

                print(f"✅ Downloaded {mod_name} to {destination_path}")
                append_to_log(f"✅ Successfully installed mod: {mod_name}")

                self._set_headers(200)
                self.wfile.write(f"✅ Mod {mod_name} downloaded and placed in plugins folder.".encode())

            except Exception as e:
                print(f"❌ Failed to add mod: {e}")
                append_to_log(f"❌ Failed to install mod {mod_name}: {e}")
                self._set_headers(500)
                self.wfile.write(f"❌ Failed to add mod: {e}".encode())

        elif self.path == '/Update_Rust':
            try:
                start_script("UpdateRustServerFour.py")
                time.sleep(3)

                if not is_script_running("UpdateRustServerFour"):
                    raise RuntimeError("UpdateRustServer.py handler didn't start or exited unexpectedly")

                append_to_log(f"⚙️ Initiating the Rust server update process")

                self.send_response(200)
                self.send_header('Access-Control-Allow-Origin', '*')
                self.end_headers()
                self.wfile.write(f"{RUST_SERVER_ID} update process started.".encode())

            except Exception as e:
                self.send_response(500)
                self.send_header('Access-Control-Allow-Origin', '*')
                self.end_headers()

                error_msg = f"❌ Failed to start Rust server update: {e}"
                self.wfile.write(f"{RUST_SERVER_ID} update process failed.".encode())
                append_to_log(error_msg)
            return

            # === FILE MANAGER ENDPOINTS ===
        else: 
            parsed = urlparse(self.path)
            path = parsed.path
            content_length = int(self.headers.get('Content-Length', 0))
            body = self.rfile.read(content_length).decode()
            try:
                data = json.loads(body) if body else {}

                if path == "/list":
                    try:
                        rel_path = data.get("path", "")
                        abs_path = secure_path(rel_path)
                        if not os.path.isdir(abs_path):
                            return self._json_response({"error": "Not a directory"}, 400)
                        files = os.listdir(abs_path)
                        return self._json_response({"files": files})
                    except Exception as e:
                        return self._json_response({"error": str(e)}, 500)

                elif path == "/read":
                    try:
                        file_path = data.get("file", "")
                        abs_path = secure_path(file_path)
                        if not os.path.isfile(abs_path):
                            return self._json_response({"error": "Not a file"}, 400)
                        with open(abs_path, "r", encoding="utf-8", errors="ignore") as f:
                            content = f.read()
                        return self._json_response({"content": content})
                    except Exception as e:
                        return self._json_response({"error": str(e)}, 500)

                elif path == "/write":
                    try:
                        file_path = data.get("file")
                        content = data.get("content", "")
                        abs_path = secure_path(file_path)
                        if not os.path.isfile(abs_path):
                            return self._json_response({"error": "File not found"}, 404)
                        with open(abs_path, "w", encoding="utf-8") as f:
                            f.write(content)
                        return self._json_response({"success": True})
                    except Exception as e:
                        return self._json_response({"error": str(e)}, 500)

                elif path == "/delete":
                    try:
                        file_path = data.get("file")
                        abs_path = secure_path(file_path)
                        if os.path.isdir(abs_path):
                            return self._json_response({"error": "Cannot delete directories"}, 400)
                        if not os.path.exists(abs_path):
                            return self._json_response({"error": "File not found"}, 404)
                        os.remove(abs_path)
                        return self._json_response({"success": True})
                    except Exception as e:
                        return self._json_response({"error": str(e)}, 500)

                elif path == "/rename":
                    try:
                        old_path = data.get("old_path")
                        new_name = data.get("new_name")
                        abs_old = secure_path(old_path)
                        parent_dir = os.path.dirname(abs_old)
                        abs_new = os.path.join(parent_dir, new_name)
                        abs_new = secure_path(os.path.relpath(abs_new, BASE_DIR))

                        if os.path.exists(abs_new):
                            return self._json_response({"error": "Target name already exists"}, 400)

                        os.rename(abs_old, abs_new)
                        return self._json_response({"success": True})
                    except Exception as e:
                        return self._json_response({"error": str(e)}, 500)

            except json.JSONDecodeError:
                self._set_headers(400)
                self.wfile.write(b"Invalid JSON")
                return

#        else:
#            self.send_response(404)
#            self.end_headers()
#            self.wfile.write(b"Invalid Command... Dumb fuck.\n")

def kill_rust_server():
    killed_any = False

    try:
        # Kill Rust_Server.py if running
        for proc in psutil.process_iter(['pid', 'name', 'cmdline']):
            try:
                cmdline = proc.info['cmdline']
                if cmdline and any("StartRustServerFour.py" in arg for arg in cmdline):
                    print(f"🔪 Killing Rust_Server (PID {proc.pid})")
                    proc.terminate()
                    proc.wait(timeout=5)
                    killed_any = True
            except (psutil.NoSuchProcess, psutil.AccessDenied):
                continue

        # Kill RustDedicated.exe if running
        for proc in psutil.process_iter(['pid', 'name']):
            try:
                if proc.info['name'] == "RustDedicated.exe":
                    print(f"🔪 Killing RustDedicated.exe (PID {proc.pid})")
                    proc.terminate()
                    proc.wait(timeout=5)
                    killed_any = True
            except (psutil.NoSuchProcess, psutil.AccessDenied):
                continue

        if not killed_any:
            print("⚠️  No Rust_Server.py or RustDedicated.exe process found.")
        else:
            print("✅ All matching processes terminated.")

    except Exception as e:
        print(f"❌ Error while killing server processes: {e}")

def start_rust_server():
    try:
        batch_path = BASE_DIR / "StartRustServerFour.py"
        subprocess.Popen(
            [sys.executable, batch_path],
            creationflags=subprocess.CREATE_NEW_CONSOLE
        )
        print("🚀 Rust server started successfully.")
    except Exception as e:
        print(f"❌ Failed to start Rust server: {e}")

def append_to_log(message):
    try:
        with open(LOG_OUTPUT_PATH, "a", encoding="utf-8") as log_file:
            log_file.write(f"{message}\n")
            log_file.flush()
    except Exception as e:
        print(f"❌ Failed to write to log file: {e}")

def secure_path(rel_path):
    abs_path = (BASE_DIR / rel_path).resolve()
    if BASE_DIR not in abs_path.parents and abs_path != BASE_DIR:
        raise PermissionError("Unauthorized path access attempt.")
    return abs_path

def start_script(script_name):
    if platform.system() == "Windows":
        si = subprocess.STARTUPINFO()
        si.dwFlags |= subprocess.STARTF_USESHOWWINDOW
        si.wShowWindow = 2

        subprocess.Popen(
            [sys.executable, script_name],
            startupinfo=si,
            creationflags=subprocess.CREATE_NEW_CONSOLE
        )
    else:
        subprocess.Popen([sys.executable, script_name])

def is_script_running(script_name):
    system = platform.system()
    try:
        if system == "Windows":
            cmd = ['wmic', 'process', 'get', 'CommandLine']
        else:
            cmd = ['ps', 'aux']

        output = subprocess.check_output(cmd, text=True, errors='ignore')
        return any(script_name in line and 'python' in line for line in output.splitlines())
    except Exception:
        return False
        
def run_server():
    server_address = ('', HTTP_PORT)
    httpd = HTTPServer(server_address, SimpleWebhookHandler)
    print(f"Rcon_Server running on port {HTTP_PORT}...")
    try:
        httpd.serve_forever()
    except KeyboardInterrupt:
        print("Shutting down server...")

if __name__ == '__main__':
    run_server()
